--[[
===================================================================
 Mineiro MuOnline - Scripts RoxGaming
 Criador : Mineiro MuOnline
 YouTube : https://www.youtube.com/@MineiroMuOnline
 Contato : +55 (31) 98255-6150  [Mineiro MuOnline / RoxGaming]
 Ano     : 2025
===================================================================
]]--
Track = {}

function Track.Command(aIndex, Arguments)
    if TRACK_SWITCH == 0 then
        return
    end
    
    local player = User.new(aIndex)
    local Language = player:getLanguage()
    
    if player:getAuthority() ~= 32 and CheckGameMasterLevel(player:getAccountID(), player:getName(), TRACK_GAME_MASTER_LEVEL) == 0 then
        return
    end
    
    local Name = command:getString(Arguments, 1, 0)
    local TargetIndex = GetIndex(Name)
    
    if TargetIndex == -1 then
        SendMessage(string.format(TRACK_MESSAGES[Language][1], Name), aIndex, 1)
        return
    end
    
    local player_target = User.new(TargetIndex)
    local targetMap = player_target:getMapNumber()
    local targetX = player_target:getX()
    local targetY = player_target:getY()
    if CheckBuffPlayer(aIndex, TRACK_EFFECT.BuffIndex) == 0 then
        AddEffect(aIndex, 0, TRACK_EFFECT.BuffIndex, 0, 0, 0, 0, 0)
        SendMessage(string.format(TRACK_MESSAGES[Language][2]), aIndex, 1)
    end
    
    local function teleportAndRemoveEffect()
        Teleport(aIndex, targetMap, targetX, targetY)
        if CheckBuffPlayer(aIndex, TRACK_EFFECT.BuffIndex) == 1 then
            RemoveEffect(aIndex, TRACK_EFFECT.BuffIndex)
        end
        SendMessage(string.format(TRACK_MESSAGES[Language][3], Name), aIndex, 1)
    end
    
    Timer.TimeOut(TRACK_EFFECT.Duration, teleportAndRemoveEffect)
    
    player = nil
    player_target = nil
end

Commands.Register(TRACK_COMMAND, Track.Command)

return Track